<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// hitung total anggota
$qAnggota = $db->query("SELECT COUNT(*) AS total FROM anggota");
$totalAnggota = $qAnggota->fetch_assoc()['total'] ?? 0;

// total simpanan (sementara contoh)
$qSimpanan = $db->query("SELECT SUM(jumlah) AS total FROM simpanan");
$totalSimpanan = $qSimpanan->fetch_assoc()['total'] ?? 0;

// total pinjaman (sementara contoh)
$qPinjaman = $db->query("SELECT SUM(jumlah) AS total FROM pinjaman");
$totalPinjaman = $qPinjaman->fetch_assoc()['total'] ?? 0;
?>

<h2>Dashboard</h2>

<div class="dashboard">

    <div class="card">
        <h3>Total Anggota</h3>
        <p><?= $totalAnggota; ?></p>
    </div>

    <div class="card">
        <h3>Total Simpanan</h3>
        <p>Rp <?= number_format($totalSimpanan, 0, ',', '.'); ?></p>
    </div>

    <div class="card">
        <h3>Total Pinjaman</h3>
        <p>Rp <?= number_format($totalPinjaman, 0, ',', '.'); ?></p>
    </div>

</div>

<?php require_once '../../templates/footer.php'; ?>
